/////////////////////////////////////////////////////////////////////////
///@system һϵͳ
///@company ϺڻϢ޹˾
///@file FtdcTraderApi.h
///@brief ˿ͻ˽ӿ
///@history 
///20060106	Ժ		ļ
///20151218			NT-0286-API֤
/////////////////////////////////////////////////////////////////////////

#if !defined(_FTDCTRADERAPI_H)
#define _FTDCTRADERAPI_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "FtdcUserApiStruct.h"

#if defined(ISLIB) && defined(WIN32)
#ifdef LIB_TRADER_API_EXPORT
#define TRADER_API_EXPORT __declspec(dllexport)
#else
#define TRADER_API_EXPORT __declspec(dllimport)
#endif
#else
#if defined(LIB_TRADER_API_EXPORT) && defined(ISLIB) && defined(UNIX)
#define TRADER_API_EXPORT  __attribute__ ((visibility("default")))
#else
#define TRADER_API_EXPORT
#endif 
#endif

class CShfeFtdcTraderSpi
{
public:
	///ͻ뽻׺̨ͨʱδ¼ǰ÷á
	virtual void OnFrontConnected(){};
	
	///ͻ뽻׺̨ͨӶϿʱ÷áAPIԶӣͻ˿ɲ
	///@param nReason ԭ
	///        0x1001 ʧ
	///        0x1002 дʧ
	///        0x2001 ʱ
	///        0x2002 ʧ
	///        0x2003 յ
	virtual void OnFrontDisconnected(int nReason){};
		
	///ʱ档ʱδյʱ÷á
	///@param nTimeLapse ϴνձĵʱ
	virtual void OnHeartBeatWarning(int nTimeLapse){};
	
	///Ļصʼ֪ͨAPIյһĺȵñȻǸĻصǱĻص֪ͨ
	///@param nTopicID 루˽ȣ
	///@param nSequenceNo 
	virtual void OnPackageStart(int nTopicID, int nSequenceNo){};
	
	///Ļص֪ͨAPIյһĺȵñĻصʼ֪ͨȻǸĻصñ
	///@param nTopicID 루˽ȣ
	///@param nSequenceNo 
	virtual void OnPackageEnd(int nTopicID, int nSequenceNo){};


	///Ӧ
	virtual void OnRspError(CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///û¼Ӧ
	virtual void OnRspUserLogin(CShfeFtdcRspUserLoginField *pRspUserLogin, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///û˳Ӧ
	virtual void OnRspUserLogout(CShfeFtdcRspUserLogoutField *pRspUserLogout, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼Ӧ
	virtual void OnRspOrderInsert(CShfeFtdcInputOrderField *pInputOrder, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspOrderAction(CShfeFtdcOrderActionField *pOrderAction, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼Ӧ
	virtual void OnRspQuoteInsert(CShfeFtdcInputQuoteField *pInputQuote, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///۲Ӧ
	virtual void OnRspQuoteAction(CShfeFtdcQuoteActionField *pQuoteAction, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///û޸Ӧ
	virtual void OnRspUserPasswordUpdate(CShfeFtdcUserPasswordUpdateField *pUserPasswordUpdate, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ִ¼Ӧ
	virtual void OnRspExecOrderInsert(CShfeFtdcInputExecOrderField *pInputExecOrder, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ִӦ
	virtual void OnRspExecOrderAction(CShfeFtdcExecOrderActionField *pExecOrderAction, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///¼Ӧ
	virtual void OnRspAdminOrderInsert(CShfeFtdcInputAdminOrderField *pInputAdminOrder, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ǳϱ¼Ӧ
	virtual void OnRspCombOrderInsert(CShfeFtdcInputCombOrderField *pInputCombOrder, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ִ¼Ӧ
	virtual void OnRspAbandonExecOrderInsert(CShfeFtdcInputAbandonExecOrderField *pInputAbandonExecOrder, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ִӦ
	virtual void OnRspAbandonExecOrderAction(CShfeFtdcAbandonExecOrderActionField *pAbandonExecOrderAction, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯ¼Ӧ
	virtual void OnRspQuoteDemand(CShfeFtdcQuoteDemandInfoField *pQuoteDemandInfo, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Ӧ
	virtual void OnRspSubscribeTopic(CShfeFtdcDisseminationField *pDissemination, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ԱʽѯӦ
	virtual void OnRspQryPartAccount(CShfeFtdcRspPartAccountField *pRspPartAccount, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryOrder(CShfeFtdcOrderField *pOrder, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///۲ѯӦ
	virtual void OnRspQryQuote(CShfeFtdcQuoteField *pQuote, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ɽѯӦ
	virtual void OnRspQryTrade(CShfeFtdcTradeField *pTrade, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ԱͻѯӦ
	virtual void OnRspQryClient(CShfeFtdcRspClientField *pRspClient, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ԱֲֲѯӦ
	virtual void OnRspQryPartPosition(CShfeFtdcRspPartPositionField *pRspPartPosition, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ͻֲֲѯӦ
	virtual void OnRspQryClientPosition(CShfeFtdcRspClientPositionField *pRspClientPosition, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ԼѯӦ
	virtual void OnRspQryInstrument(CShfeFtdcRspInstrumentField *pRspInstrument, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///Լ״̬ѯӦ
	virtual void OnRspQryInstrumentStatus(CShfeFtdcInstrumentStatusField *pInstrumentStatus, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ֵӦ
	virtual void OnRspQryHedgeVolume(CShfeFtdcHedgeVolumeField *pHedgeVolume, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///޶ѯӦ
	virtual void OnRspQryCreditLimit(CShfeFtdcCreditLimitField *pCreditLimit, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ǱϱѯӦ
	virtual void OnRspQryCombOrder(CShfeFtdcCombOrderField *pCombOrder, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ִѯӦ
	virtual void OnRspQryExecOrder(CShfeFtdcExecOrderField *pExecOrder, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ִѯӦ
	virtual void OnRspQryAbandonExecOrder(CShfeFtdcAbandonExecOrderField *pAbandonExecOrder, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ͨѯӦ
	virtual void OnRspQryMarketData(CShfeFtdcMarketDataField *pMarketData, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryBulletin(CShfeFtdcBulletinField *pBulletin, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ѯӦ
	virtual void OnRspQryTopic(CShfeFtdcDisseminationField *pDissemination, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ԼλѯӦ
	virtual void OnRspQryMBLMarketData(CShfeFtdcMBLMarketDataField *pMBLMarketData, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ϢѯӦ
	virtual void OnRspQryInformation(CShfeFtdcInformationField *pInformation, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};

	///ɽر
	virtual void OnRtnTrade(CShfeFtdcTradeField *pTrade) {};

	///ر
	virtual void OnRtnOrder(CShfeFtdcOrderField *pOrder) {};

	///ִر
	virtual void OnRtnExecOrder(CShfeFtdcExecOrderField *pExecOrder) {};

	///ۻر
	virtual void OnRtnQuote(CShfeFtdcQuoteField *pQuote) {};

	///Ǳϱر
	virtual void OnRtnCombOrder(CShfeFtdcCombOrderField *pCombOrder) {};

	///ִر
	virtual void OnRtnAbandonExecOrder(CShfeFtdcAbandonExecOrderField *pAbandonExecOrder) {};

	///Լ״̬֪ͨ
	virtual void OnRtnInstrumentStatus(CShfeFtdcInstrumentStatusField *pInstrumentStatus) {};

	///ӺԼ֪ͨ
	virtual void OnRtnInsInstrument(CShfeFtdcInstrumentField *pInstrument) {};

	///ɾԼ֪ͨ
	virtual void OnRtnDelInstrument(CShfeFtdcInstrumentField *pInstrument) {};

	///ӺԼ֪ͨ
	virtual void OnRtnInsCombinationLeg(CShfeFtdcCombinationLegField *pCombinationLeg) {};

	///ɾԼ֪ͨ
	virtual void OnRtnDelCombinationLeg(CShfeFtdcCombinationLegField *pCombinationLeg) {};

	///֪ͨ
	virtual void OnRtnAliasDefine(CShfeFtdcAliasDefineField *pAliasDefine) {};

	///֪ͨ
	virtual void OnRtnFlowMessageCancel(CShfeFtdcFlowMessageCancelField *pFlowMessageCancel) {};

	///֪ͨ
	virtual void OnRtnBulletin(CShfeFtdcBulletinField *pBulletin) {};

	///¼ر
	virtual void OnErrRtnOrderInsert(CShfeFtdcInputOrderField *pInputOrder, CShfeFtdcRspInfoField *pRspInfo) {};

	///ر
	virtual void OnErrRtnOrderAction(CShfeFtdcOrderActionField *pOrderAction, CShfeFtdcRspInfoField *pRspInfo) {};

	///¼ر
	virtual void OnErrRtnQuoteInsert(CShfeFtdcInputQuoteField *pInputQuote, CShfeFtdcRspInfoField *pRspInfo) {};

	///۲ر
	virtual void OnErrRtnQuoteAction(CShfeFtdcQuoteActionField *pQuoteAction, CShfeFtdcRspInfoField *pRspInfo) {};

	///ִ¼ر
	virtual void OnErrRtnExecOrderInsert(CShfeFtdcInputExecOrderField *pInputExecOrder, CShfeFtdcRspInfoField *pRspInfo) {};

	///ִر
	virtual void OnErrRtnExecOrderAction(CShfeFtdcExecOrderActionField *pExecOrderAction, CShfeFtdcRspInfoField *pRspInfo) {};

	///Ǳϱ¼ر
	virtual void OnErrRtnCombOrderInsert(CShfeFtdcInputCombOrderField *pInputCombOrder, CShfeFtdcRspInfoField *pRspInfo) {};

	///ִ¼ر
	virtual void OnErrRtnAbandonExecOrderInsert(CShfeFtdcInputAbandonExecOrderField *pInputAbandonExecOrder, CShfeFtdcRspInfoField *pRspInfo) {};

	///ִر
	virtual void OnErrRtnAbandonExecOrderAction(CShfeFtdcAbandonExecOrderActionField *pAbandonExecOrderAction, CShfeFtdcRspInfoField *pRspInfo) {};

	///ѯַ
	virtual void OnRtnQuoteDemandNotify(CShfeFtdcQuoteDemandNotifyField *pQuoteDemandNotify) {};

	///ʲѯӦ
	virtual void OnRspQryExchangeRate(CShfeFtdcRspExchangeRateField *pRspExchangeRate, CShfeFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {};
};

class TRADER_API_EXPORT CShfeFtdcTraderApi
{
public:
	///TraderApi
	///@param pszFlowPath ϢļĿ¼ĬΪǰĿ¼
	///@return UserApi
	static CShfeFtdcTraderApi *CreateFtdcTraderApi(const char *pszFlowPath = "");
	
	///ȡϵͳ汾
	///@param nMajorVersion 汾
	///@param nMinorVersion Ӱ汾
	///@return ϵͳʶַ
	static const char *GetVersion(int &nMajorVersion, int &nMinorVersion);
	
	///ɾӿڶ
	///@remark ʹñӿڶʱ,øúɾӿڶ
	virtual void Release() = 0;
	
	///ʼ
	///@remark ʼл,ֻеú,ӿڲſʼ
	virtual void Init() = 0;
	
	///ȴӿ߳̽
	///@return ߳˳
	virtual int Join() = 0;
	
	///ȡǰ
	///@retrun ȡĽ
	///@remark ֻе¼ɹ,ܵõȷĽ
	virtual const char *GetTradingDay() = 0;
	
	///עǰûַ
	///@param pszFrontAddressǰûַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:17001 
	///@remark tcpЭ飬127.0.0.1ַ17001˿ںš
	virtual void RegisterFront(char *pszFrontAddress) = 0;
	
	///עַַ
	///@param pszNsAddressַַ
	///@remark ַĸʽΪprotocol://ipaddress:port磺tcp://127.0.0.1:12001 
	///@remark tcpЭ飬127.0.0.1ַ12001˿ںš
	///@remark RegisterFrontRegisterNameServer
	virtual void RegisterNameServer(char *pszNsAddress) = 0;
	
	///עصӿ
	///@param pSpi Իصӿʵ
	virtual void RegisterSpi(CShfeFtdcTraderSpi *pSpi) = 0;
	
	///֤
	///@param pszCertFileName û֤ļ
	///@param pszKeyFileName û˽Կļ
	///@param pszCaFileName CA֤ļ
	///@param pszKeyFilePassword û˽Կļ
	///@return 0 ɹ
	///@return -1 CA֤ʧ
	///@return -2 û֤ʧ
	///@return -3 û˽Կʧ	
	///@return -4 û֤Уʧ
	virtual int RegisterCertificateFile(const char *pszCertFileName, const char *pszKeyFileName, 
		const char *pszCaFileName, const char *pszKeyFilePassword) = 0;

	///ע㷨
	///@param pszKeyFileName Կļ
	///@param pszKeyFilePassword Կļ
	///@param nEncryptType Կ
	///@return 0 ɹ
	///@return -1 ȡԿļʧ
	///@return -2 ûԿʧ
	///@return -3 ֵ֧㷨
	virtual int RegisterCryptAlgorithm(const char* pszKeyFileName, const char *pszKeyFilePassword,
		TShfeFtdcEncryptTypeType nEncryptType = SHFE_FTDC_ET_RSA) = 0;
		
	///˽
	///@param nResumeType ˽شʽ  
	///        TERT_RESTART:ӱտʼش
	///        TERT_RESUME:ϴյ
	///        TERT_QUICK:ֻ͵¼˽
	///@remark ÷ҪInitǰá򲻻յ˽ݡ
	virtual void SubscribePrivateTopic(TE_RESUME_TYPE nResumeType) = 0;
	
	///Ĺ
	///@param nResumeType شʽ  
	///        TERT_RESTART:ӱտʼش
	///        TERT_RESUME:ϴյ
	///        TERT_QUICK:ֻ͵¼󹫹
	///@remark ÷ҪInitǰá򲻻յݡ
	virtual void SubscribePublicTopic(TE_RESUME_TYPE nResumeType) = 0;

	///ĽԱ
	///@param nResumeType Աشʽ  
	///        TERT_RESTART:ӱտʼش
	///        TERT_RESUME:ϴյ
	///        TERT_QUICK:ֻ͵¼Ա
	///@remark ÷ҪInitǰá򲻻յԱݡ
	virtual void SubscribeUserTopic(TE_RESUME_TYPE nResumeType) = 0;
	
	///ʱʱ䡣
	///@param timeout ʱʱ()  
	virtual void SetHeartbeatTimeout(unsigned int timeout) = 0;
	
	///־ļ
	///@param pszReqLogFileName ־ļ  
	///@return 0 ɹ
	///@return -1 ־ļʧ
	virtual int OpenRequestLog(const char *pszReqLogFileName) = 0;

	///Ӧ־ļ
	///@param pszRspLogFileName Ӧ־ļ  
	///@return 0 ɹ
	///@return -1 ־ļʧ
	virtual int OpenResponseLog(const char *pszRspLogFileName) = 0;


	///û¼
	virtual int ReqUserLogin(CShfeFtdcReqUserLoginField *pReqUserLogin, int nRequestID) = 0;

	///û˳
	virtual int ReqUserLogout(CShfeFtdcReqUserLogoutField *pReqUserLogout, int nRequestID) = 0;

	///¼
	virtual int ReqOrderInsert(CShfeFtdcInputOrderField *pInputOrder, int nRequestID) = 0;

	///
	virtual int ReqOrderAction(CShfeFtdcOrderActionField *pOrderAction, int nRequestID) = 0;

	///¼
	virtual int ReqQuoteInsert(CShfeFtdcInputQuoteField *pInputQuote, int nRequestID) = 0;

	///۲
	virtual int ReqQuoteAction(CShfeFtdcQuoteActionField *pQuoteAction, int nRequestID) = 0;

	///û޸
	virtual int ReqUserPasswordUpdate(CShfeFtdcUserPasswordUpdateField *pUserPasswordUpdate, int nRequestID) = 0;

	///ִ¼
	virtual int ReqExecOrderInsert(CShfeFtdcInputExecOrderField *pInputExecOrder, int nRequestID) = 0;

	///ִ
	virtual int ReqExecOrderAction(CShfeFtdcExecOrderActionField *pExecOrderAction, int nRequestID) = 0;

	///¼
	virtual int ReqAdminOrderInsert(CShfeFtdcInputAdminOrderField *pInputAdminOrder, int nRequestID) = 0;

	///Ǳϱ¼
	virtual int ReqCombOrderInsert(CShfeFtdcInputCombOrderField *pInputCombOrder, int nRequestID) = 0;

	///ִ¼
	virtual int ReqAbandonExecOrderInsert(CShfeFtdcInputAbandonExecOrderField *pInputAbandonExecOrder, int nRequestID) = 0;

	///ִ
	virtual int ReqAbandonExecOrderAction(CShfeFtdcAbandonExecOrderActionField *pAbandonExecOrderAction, int nRequestID) = 0;

	///ѯ¼
	virtual int ReqQuoteDemand(CShfeFtdcInputQuoteDemandField *pInputQuoteDemand, int nRequestID) = 0;

	///
	virtual int ReqSubscribeTopic(CShfeFtdcDisseminationField *pDissemination, int nRequestID) = 0;

	///Աʽѯ
	virtual int ReqQryPartAccount(CShfeFtdcQryPartAccountField *pQryPartAccount, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryOrder(CShfeFtdcQryOrderField *pQryOrder, int nRequestID) = 0;

	///۲ѯ
	virtual int ReqQryQuote(CShfeFtdcQryQuoteField *pQryQuote, int nRequestID) = 0;

	///ɽѯ
	virtual int ReqQryTrade(CShfeFtdcQryTradeField *pQryTrade, int nRequestID) = 0;

	///Աͻѯ
	virtual int ReqQryClient(CShfeFtdcQryClientField *pQryClient, int nRequestID) = 0;

	///Աֲֲѯ
	virtual int ReqQryPartPosition(CShfeFtdcQryPartPositionField *pQryPartPosition, int nRequestID) = 0;

	///ͻֲֲѯ
	virtual int ReqQryClientPosition(CShfeFtdcQryClientPositionField *pQryClientPosition, int nRequestID) = 0;

	///Լѯ
	virtual int ReqQryInstrument(CShfeFtdcQryInstrumentField *pQryInstrument, int nRequestID) = 0;

	///Լ״̬ѯ
	virtual int ReqQryInstrumentStatus(CShfeFtdcQryInstrumentStatusField *pQryInstrumentStatus, int nRequestID) = 0;

	///ֵȲѯ
	virtual int ReqQryHedgeVolume(CShfeFtdcQryHedgeVolumeField *pQryHedgeVolume, int nRequestID) = 0;

	///޶ѯ
	virtual int ReqQryCreditLimit(CShfeFtdcQryCreditLimitField *pQryCreditLimit, int nRequestID) = 0;

	///Ǳϱѯ
	virtual int ReqQryCombOrder(CShfeFtdcQryCombOrderField *pQryCombOrder, int nRequestID) = 0;

	///ִѯ
	virtual int ReqQryExecOrder(CShfeFtdcQryExecOrderField *pQryExecOrder, int nRequestID) = 0;

	///ִѯ
	virtual int ReqQryAbandonExecOrder(CShfeFtdcQryAbandonExecOrderField *pQryAbandonExecOrder, int nRequestID) = 0;

	///ͨѯ
	virtual int ReqQryMarketData(CShfeFtdcQryMarketDataField *pQryMarketData, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryBulletin(CShfeFtdcQryBulletinField *pQryBulletin, int nRequestID) = 0;

	///ѯ
	virtual int ReqQryTopic(CShfeFtdcDisseminationField *pDissemination, int nRequestID) = 0;

	///Լλѯ
	virtual int ReqQryMBLMarketData(CShfeFtdcQryMBLMarketDataField *pQryMBLMarketData, int nRequestID) = 0;

	///Ϣѯ
	virtual int ReqQryInformation(CShfeFtdcQryInformationField *pQryInformation, int nRequestID) = 0;

	///ʲѯ
	virtual int ReqQryExchangeRate(CShfeFtdcQryExchangeRateField *pQryExchangeRate, int nRequestID) = 0;
protected:
	~CShfeFtdcTraderApi(){};
};

#endif
